barcodeFiles = c(
"zf_034.txt",
"zf_036.txt",
"zfm19.txt",
"zfm25.txt",
"zfm18.txt",
"zfm21.txt",
"bmp1a_16.txt",
"bmp1a_17.txt",
"bmp1a_19.txt",
"plod2_13.txt",
"plod2_14.txt",
"plod2_15.txt",
"ab young_01.txt",
"ab young_02.txt",
"ab young_03.txt",
"ab young_04.txt")

# genotype of each animal
groupIDs = t(c("ARO","ARO","ARO","ARO","ARO","ARO","bmp1a+/+","bmp1a+/+","bmp1a+/+","plod2+/+","plod2+/+","plod2+/+","AB","AB","AB","AB"))
standardLengths = c(19.0,18.4,24.4,27.9,31.8,30.6,24.8,27.1,25.4,27.1,28.1,28.5,21.1,21.0,20.7,19.7)

paramsToAnalyze = c(3:5,11:13,19:21,26) #params to analyze
vertsToAnalyze = c(1:16)

#calculate mean coordinate
meanCoordVal = mean(standardLengths)

#read in a and b
a = scan("aMatrix.txt")
b = scan("bMatrix.txt")

for (n in 1:length(groupIDs)) {
	fishDataInit = read.table(barcodeFiles[n],header=T)
	fishData = unlist(fishDataInit[vertsToAnalyze,paramsToAnalyze])
	
	X0 = meanCoordVal
	Xi = standardLengths[n]
	Yi = fishData
	
	# transform Yi
	Yi[49:64] = fishData[49:64]*fishData[1:16]*(1e-9)
	Yi[65:80] = fishData[65:80]*fishData[17:32]*(1e-9)
	Yi[81:96] = fishData[81:96]*fishData[33:48]*(1e-9)
	
	YiStar = array(0,length(fishData))
	for (k in 1:length(fishData)) {
		YiStar[k] = Yi[k]*((X0/Xi)^b[k])
	}
	
	newFishData = YiStar
	newFishData[49:64] = YiStar[49:64]/YiStar[1:16]/(1e-9)
	newFishData[65:80] = YiStar[65:80]/YiStar[17:32]/(1e-9)
	newFishData[81:96] = YiStar[81:96]/YiStar[33:48]/(1e-9)
	
	fileData = read.table(barcodeFiles[n],header=T)
	fileData[vertsToAnalyze,paramsToAnalyze] = newFishData
	write.table(fileData,gsub(".txt","_si.txt",barcodeFiles[n]))

}

k = 10

p = paramsToAnalyze[k]

barcodeFiles = c(
"zf_034.txt",
"zf_036.txt",
"zfm19.txt",
"zfm25.txt",
"zfm18.txt",
"zfm21.txt")
groupIDs = t(c("ARO","ARO","ARO","ARO","ARO","ARO"))
standardLengths = c(19.0,18.4,24.4,27.9,31.8,30.6)
		
# retrieve values
allData = matrix(0,nrow=length(groupIDs),ncol=length(vertsToAnalyze))
for (i in 1:length(groupIDs)) {
	allDataInit = read.table(barcodeFiles[i],header=T)
	allData[i,] = unlist(allDataInit[vertsToAnalyze,p])
}

y = allData[,1]
cv1 = sd(y)/mean(y)
y1 = y/max(y)

y = allData[,1]/standardLengths
cv2 = sd(y)/mean(y)
y2 = y/max(y)

barcodeFiles = c(
"zf_034_si.txt",
"zf_036_si.txt",
"zfm19_si.txt",
"zfm25_si.txt",
"zfm18_si.txt",
"zfm21_si.txt")

# retrieve values
allData = matrix(0,nrow=length(groupIDs),ncol=length(vertsToAnalyze))
for (i in 1:length(groupIDs)) {
	allDataInit = read.table(barcodeFiles[i],header=T)
	allData[i,] = unlist(allDataInit[vertsToAnalyze,p])
}

y = allData[,1]
cv3 = sd(y)/mean(y)
y3 = y/max(y)
